<?php

//direct checkout
// add_filter('add_to_cart_redirect', 'poker_redirect_to_checkout');
if (!function_exists('poker_redirect_to_checkout')) {
    function poker_redirect_to_checkout()
    {
        global $woocommerce;
        $checkout_url = $woocommerce->cart->get_checkout_url();
        return $checkout_url;
    }
}


add_filter('woocommerce_enqueue_styles', 'poker_woocommerce_styles_upgrade', 10, 1);
if (!function_exists('poker_woocommerce_styles_upgrade')) {
    function poker_woocommerce_styles_upgrade($styles)
    {
        $updated = false;
        if (is_checkout() || is_cart()) {
            $updated = $styles;
        }
        return $updated;
    }
}


add_filter('woocommerce_new_customer_data', 'poker_wc_assign_custom_role', 10, 1);
if (!function_exists('poker_wc_assign_custom_role')) {
    function poker_wc_assign_custom_role($args)
    {
        $args['role'] = 'subscriber';
        return $args;
    }
}

add_action('woocommerce_order_status_processing', 'poker_order_status_competed', 10, 1);
if (!function_exists('poker_order_status_competed')) {
    function poker_order_status_competed($order_id)
    {
        $order = wc_get_order($order_id);
        if ($order) {
            $user_id = $order->get_user_id();
            $additional_chips = 0;
            foreach ($order->get_items() as $item_id => $item) {
                $additional_chips += get_field('additional_chips', $item_id);
            }
            $additional_chips += get_field('additional_chips', 'user_' . $user_id);

            //adding extra chips to user after order complete
            update_field('additional_chips', $additional_chips, 'user_' . $user_id);
        }
    }
}

/*add_filter( 'woocommerce_cart_needs_shipping', 'poker_filter_cart_needs_shipping_callback' );
if(!function_exists('poker_filter_cart_needs_shipping_callback')){
    function poker_filter_cart_needs_shipping_callback( $needs_shipping ){

        foreach ( WC()->cart->get_cart() as $item ) {
            if ( has_term('membership', 'product_cat', $item['data']->get_id()) ) {
                $needs_shipping = false;
                break;
            }
        } 
	
        return $needs_shipping;
    }
    
} */